<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('scheduled_nmap_scans', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->nullable()->constrained('users')->nullOnDelete();
            $table->foreignId('nmap_profile_id')->nullable()->constrained('nmap_profiles')->nullOnDelete();
            $table->string('name');
            $table->text('parameters');
            $table->string('schedule_type');
            $table->string('schedule_value');
            $table->timestamp('last_run_at')->nullable();
            $table->integer('times_ran')->default(0);
            $table->boolean('enabled')->default(true);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('scheduled_nmap_scans');
    }
};
