<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('nmap_scans', function (Blueprint $table) {
            $table->foreignId('nmap_profile_id')->nullable()->constrained('nmap_profiles')->nullOnDelete();
            $table->foreignId('scheduled_nmap_scan_id')->nullable()->constrained('scheduled_nmap_scans')->nullOnDelete();

            $table->index('nmap_profile_id');
            $table->index('scheduled_nmap_scan_id');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('nmap_scans', function (Blueprint $table) {
            $table->dropForeign(['nmap_profile_id']);
            $table->dropForeign(['scheduled_nmap_scan_id']);

            $table->dropIndex(['nmap_profile_id']);
            $table->dropIndex(['scheduled_nmap_scan_id']);

            $table->dropColumn('nmap_profile_id');
            $table->dropColumn('scheduled_nmap_scan_id');
        });
    }
};
