<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('scheduled_nmap_scans', function (Blueprint $table) {
            if (!Schema::hasColumn('scheduled_nmap_scans', 'schedule_parameters')) {
                $table->json('schedule_parameters')->nullable()->after('schedule_type');
            }

            if (Schema::hasColumn('scheduled_nmap_scans', 'schedule_value')) {
                $table->dropColumn('schedule_value');
            }
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('scheduled_nmap_scans', function (Blueprint $table) {
            if (Schema::hasColumn('scheduled_nmap_scans', 'schedule_parameters')) {
                $table->dropColumn('schedule_parameters');
            }

            if (!Schema::hasColumn('scheduled_nmap_scans', 'schedule_value')) {
                $table->string('schedule_value')->nullable()->after('schedule_type');
            }
        });
    }
};
