<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('suricata_rulesets', function (Blueprint $table) {
            $table->string('name')->primary();
            $table->text('description')->nullable();
            $table->string('type')->nullable();
            $table->string('update_frequency')->nullable();
            $table->boolean('enabled')->default(false);
            $table->string('url')->nullable();
            $table->boolean('secret_code_required')->default(false);
            $table->string('secret_code')->nullable();
            $table->timestamp('last_updated')->nullable();
            $table->string('fetch_status');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('suricata_rulesets');
    }
};
