<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('checks', function (Blueprint $table) {
            $table->id();
            $table->boolean('active')->default(true);
            $table->string('name')->default("new check");
            $table->enum('object_type', ['source', 'sourcegroup'])->default('source');
            $table->bigInteger('object_id');
            $table->enum('metric', ['bytes', 'flows', 'packets', 'bits/sec', 'abnormal_behavior'])->default('bytes');
            $table->bigInteger('warning')->default(0);
            $table->bigInteger('critical')->default(0);
            $table->string('raw_query')->nullable();
            $table->string('last_val')->nullable();
            $table->timestamp('last_run')->nullable();
            $table->smallInteger('last_code')->nullable();
            $table->string('last_stdout')->nullable();
            $table->timestamps();
        });

        Schema::create('nagios_servers', function (Blueprint $table) {
            $table->id();
            $table->string('name')->unique();
            $table->string('nrdp_url');
            $table->string('nrdp_token');
            $table->timestamps();
        });

        Schema::create('nagios_servers_hosts_services', function (Blueprint $table) {
            $table->id();
            $table->string('hostname');
            $table->string('servicename')->nullable();
            $table->bigInteger('server_id');
            $table->timestamps();
        });

        Schema::create('commands', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('location');
            $table->string('script');
            $table->string('arguments');
            $table->timestamps();
        });

        Schema::create('snmp_receivers', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->integer('version');
            $table->string('community_string');
            $table->string('auth_level');
            $table->enum('priv_protocol', ['AES', 'DES']);
            $table->string('priv_password');
            $table->enum('auth_protocol', ['MD5', 'SHA']);
            $table->string('auth_password');
            $table->string('username');
            $table->integer('port');
            $table->string('ip')->unique();
            $table->timestamps();
        });

        Schema::create('alerting_associations', function (Blueprint $table) {
            $table->id();
            $table->bigInteger('check_id');
            $table->enum('association_type', ['users', 'nagios', 'snmp_receivers', 'commands']);
            $table->bigInteger('association_id');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('checks');
    }
};
