<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('checks', function (Blueprint $table) {
            // add new metric enum values and change column
            $table->enum('metric', ['bytes', 'flows', 'packets', 'pps', 'bps', 'bpp', 'abnormal_behavior'])->default('bytes')->change();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('checks', function (Blueprint $table) {
            // revert metric enum to original values
            $table->enum('metric', ['bytes', 'flows', 'packets', 'bits/sec', 'abnormal_behavior'])->default('bytes')->change();
        });
    }
};
