<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::rename("nagios_servers_hosts_services", "service_hostnames");
        Schema::table('alerting_associations', function (Blueprint $table) {
            $table->enum('association_type', ['user', 'nagios', 'snmp_receiver', 'command'])->default('user')->change();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::rename("service_hostnames", "nagios_servers_hosts_services");
        Schema::table('alerting_associations', function (Blueprint $table) {
            $table->enum('association_type', ['users', 'nagios', 'snmp_receivers', 'commands'])->default('users')->change();
        });
    }
};
