<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('snmp_receivers', function (Blueprint $table) {
            $table->enum('version', ['2c', '3'])->change();
            $table->string('community_string')->nullable()->change();
            $table->string('auth_level')->nullable()->change();
            $table->string('priv_protocol')->nullable()->change();
            $table->string('priv_password')->nullable()->change();
            $table->string('auth_protocol')->nullable()->change();
            $table->string('auth_password')->nullable()->change();
            $table->string('username')->nullable()->change();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('snmp_receivers', function (Blueprint $table) {
            $table->integer('version')->change();
        });
    }
};
