<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('suricata_alert', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->unsignedBigInteger('signature_id');
            $table->text('signature_name');
            $table->string('category', 255)->nullable();
            $table->tinyInteger('severity')->unsigned()->nullable();
            $table->unsignedInteger('last_day_count')->default(0); 
            $table->unsignedInteger('last_hour_count')->default(0);
            $table->timestamp('last_seen');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('suricata_alert');
    }
};
