<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('suricata_scan', function (Blueprint $table) {
            $table->id();
            $table->integer('pid')->nullable();
            $table->boolean('running')->default(false);
            $table->timestamp('last_rotated')->nullable();
            $table->timestamp('started_at')->nullable();
            $table->unsignedBigInteger('eve_current_line')->default(0);
            $table->string('current_eve_log')->nullable()->default("eve.json");
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('suricata_scan');
    }
};
