<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('dashlets', function (Blueprint $table) {
            $table->dropColumn('options');
            $table->dropColumn('name');
            $table->json('vis_options')->nullable();
            $table->json('data_options')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('dashlets', function (Blueprint $table) {
            $table->json('options');
            $table->string('name', length: 255);
            $table->dropColumn('vis_options');
            $table->dropColumn('data_options');
        });
    }
};
