<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('checks', function (Blueprint $table) {
            $table->string('object_type')->default('source')->change();
            $table->string('metric')->default('bytes')->change();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('checks', function (Blueprint $table) {
            $table->enum('object_type', ['source', 'sourcegroup'])->default('source')->change();
            $table->enum('metric', ['bytes', 'flows', 'packets', 'pps', 'bps', 'bpp', 'abnormal_behavior'])->default('bytes')->change();
        });
    }
};
