<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('wireshark_ring_buffers', function (Blueprint $table) {
            $table->id();
            $table->string('interfaces');
            $table->unsignedInteger('pid')->nullable();
            $table->string('directory');
            $table->unsignedInteger('number_of_files');
            $table->unsignedInteger('file_size'); // tshark takes in kB
            $table->unsignedInteger('total_file_size');
            $table->timestamp('started_at')->nullable();
            $table->timestamp('finished_at')->nullable();
            $table->string('status')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('wireshark_ring_buffers');
    }
};
