<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::dropIfExists('reports');
        Schema::create('reports', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('dashboard_id');
            $table->foreign('dashboard_id')->references('id')->on('dashboards')->onDelete('cascade');
            $table->string('name');
            $table->string('schedule');
            $table->string('format');
            $table->json('recipients');
            $table->unsignedBigInteger('created_by');
            $table->foreign('created_by')->references('id')->on('users')->onDelete('cascade');
            $table->boolean('enabled')->default(true);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('reports');
        Schema::create('reports', function (Blueprint $table) {
            $table->id();
            $table->string('name')->unique();
            $table->integer('top')->default(5);
            $table->string('toptype');
            $table->string('toporder');
            $table->string('begindate');
            $table->string('enddate')->default('-1 second');
            $table->boolean('editable')->default(true);
            $table->string('rawquery')->nullable();
        });
    }
};
