<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class DashletSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        DB::table('dashlets')->insert([
            'created_at' => now('UTC'),
            'updated_at' => now('UTC'),
            'title' => 'New Dashlet',
            'description' => 'New Description',
            'height' => 10,
            'width' => 10,
            'vis_options' => json_encode([
                'type' => 'area',
                'area_options' => [
                    'type' => 'natural',
                    'legend' => true,
                    'stacked' => 'yes',
                    'gradient' => true,
                ],
            ]),
        ]);
    }
}
