<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\NmapProfile;

class NmapProfileSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $defaultNmapProfiles = [
            [
                'name'        => 'Intense Scan',
                'parameters'  => '-T4 -A -v',
                'description' => 'Performs a comprehensive scan with OS detection, version detection, script scanning, and traceroute. Uses aggressive timing for faster results.',
                'tags'        => ['Aggressive', 'OS Detection', 'Version Detection', 'Script', 'Traceroute', 'Comprehensive'],
                'user_id'     => 1,
            ],
            [
                'name'        => 'Intense Scan plus UDP',
                'parameters'  => '-sS -sU -T4 -A -v',
                'description' => 'Performs a comprehensive scan with both TCP SYN and UDP scans, OS detection, version detection, script scanning, and traceroute. Aggressive timing is used.',
                'tags'        => ['Aggressive', 'TCP SYN', 'UDP', 'OS Detection', 'Version Detection', 'Script', 'Traceroute', 'Comprehensive'],
                'user_id'     => 1,
            ],
            [
                'name'        => 'Intense Scan on all TCP ports',
                'parameters'  => '-p 1-65535 -T4 -A -v',
                'description' => 'Scans all 65535 TCP ports with OS detection, version detection, script scanning, and traceroute. Uses aggressive timing.',
                'tags'        => ['Aggressive', 'All TCP Ports', 'OS Detection', 'Version Detection', 'Script', 'Traceroute', 'Comprehensive'],
                'user_id'     => 1,
            ],
            [
                'name'        => 'Intense Scan with no ping',
                'parameters'  => '-T4 -A -v -Pn',
                'description' => 'Performs a comprehensive scan with OS detection, version detection, script scanning, and traceroute, skipping host discovery (treats all hosts as online).',
                'tags'        => ['Aggressive', 'No Ping', 'OS Detection', 'Version Detection', 'Script', 'Traceroute', 'Comprehensive'],
                'user_id'     => 1,
            ],
            [
                'name'        => 'Ping Scan',
                'parameters'  => '-sn',
                'description' => 'Discovers which hosts are up in the network without scanning ports (host discovery only).',
                'tags'        => ['Host Discovery', 'Ping', 'No Port Scan', 'Quick'],
                'user_id'     => 1,
            ],
            [
                'name'        => 'Quick Scan',
                'parameters'  => '-T4 -F',
                'description' => 'Scans the most common 100 ports using aggressive timing for speed.',
                'tags'        => ['Quick', 'Fast', 'Top Ports'],
                'user_id'     => 1,
            ],
            [
                'name'        => 'Quick Scan+',
                'parameters'  => '-sV -T4 -O -F',
                'description' => 'Scans the most common 100 ports with service version detection and OS detection, using aggressive timing.',
                'tags'        => ['Quick', 'Fast', 'Top Ports', 'Version Detection', 'OS Detection'],
                'user_id'     => 1,
            ],
            [
                'name'        => 'Quick Traceroute',
                'parameters'  => '-sn --traceroute',
                'description' => 'Performs host discovery and traceroute to each host, without port scanning.',
                'tags'        => ['Host Discovery', 'Traceroute', 'No Port Scan', 'Quick'],
                'user_id'     => 1,
            ],
            [
                'name'        => 'Slow Comprehensive Scan',
                'parameters'  => '-sS -sU -T4 -A -v -PE -PP -PS80,443 -PA3389 -PU40125 -PY -g 53 --script "default or (discovery and safe)"',
                'description' => 'Performs a very thorough scan with TCP SYN and UDP scans, OS and version detection, multiple host discovery techniques, custom source port, and safe scripts. Suitable for comprehensive assessments.',
                'tags'        => ['Comprehensive', 'TCP SYN', 'UDP', 'OS Detection', 'Version Detection', 'Script', 'Host Discovery', 'Safe', 'Slow'],
                'user_id'     => 1,
            ],
        ];

        foreach ($defaultNmapProfiles as $profile) {
            NmapProfile::create($profile);
        }
    }
}
