<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Report;

class ReportsTableSeeder extends Seeder
{
    public function run(): void
    {
        $defaultReports = [
            [
                'name' => 'Top 5 Talkers By Source IP (Last 24 Hours)',
                'top' => 5,
                'toptype' => 'srcip',
                'toporder' => 'bytes',
                'begindate' => '-24 hours',
                'enddate' => '-1 second',
                'editable' => false,
                'rawquery' => null,
            ],
            [
                'name' => 'Top 5 Talkers By Destination IP (Last 24 Hours)',
                'top' => 5,
                'toptype' => 'dstip',
                'toporder' => 'bytes',
                'begindate' => '-24 hours',
                'enddate' => '-1 second',
                'editable' => false,
                'rawquery' => null,
            ],
            [
                'name' => 'Top 5 Talkers By Source Port (Last 24 Hours)',
                'top' => 5,
                'toptype' => 'srcport',
                'toporder' => 'bytes',
                'begindate' => '-24 hours',
                'enddate' => '-1 second',
                'editable' => false,
                'rawquery' => null,
            ],
            [
                'name' => 'Top 5 Talkers By Destination Port (Last 24 Hours)',
                'top' => 5,
                'toptype' => 'dstport',
                'toporder' => 'bytes',
                'begindate' => '-24 hours',
                'enddate' => '-1 second',
                'editable' => false,
                'rawquery' => null,
            ],
        ];

        foreach ($defaultReports as $report) {
            Report::firstOrCreate(
                ['name' => $report['name']],
                $report
            );
        }
    }
}


