<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class SourceGroupLinkerSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $sources = DB::table('sources')->pluck('id');
    
        foreach ($sources as $sourceId) {
            DB::table('source_group_linker')->updateOrInsert([
                'source_group_id' => 1,
                'source_id' => $sourceId,
            ]);
        }
    }
}
