<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Symfony\Component\Yaml\Yaml;
use App\Models\SuricataRuleset;
use Illuminate\Support\Facades\Process;

class SuricataRulesetSeeder extends Seeder
{
    public function run(): void
    {
        $index = Yaml::parseFile("/usr/local/var/lib/suricata/update/cache/index.yaml");
    
        foreach ($index['sources'] as $name => $source) {
            $hasSecretCode = array_key_exists('secret-code', $source['parameters'] ?? []);
            $type = $hasSecretCode ? 'Commercial' : 'Open';
            if ($name == "ptrules/open") continue;
            $data = [
                'name'              => $name,
                'description'       => $source['summary'] ?? null,
                'type'              => $type,
                'url'               => $source['url'] ?? null,
                'enabled'           => $name == "et/open" ? true : false,
                'update_frequency'  => 'Daily', 
                'secret_code_required' => $hasSecretCode ? true : false,
                'secret_code'       => null,
                'last_updated'      => null,
                'fetch_status'      => "None",
            ];
            SuricataRuleset::updateOrCreate(['name' => $name], $data);
        }
    }
}
