<?php

use Illuminate\Support\Facades\Broadcast;
use App\Models\User;

Broadcast::channel('NNA.Admins', function (User $user) {
    \Log::info('Broadcast auth for NNA Admins channel', [
        'user_id' => $user->id,
        'is_admin' => $user->is_admin,
        'return' => 1 === $user->is_admin,
    ]);

    return $user->is_admin;
});

Broadcast::channel('App.Models.User.{id}', function ($user, $id) {
    return true;
});
