<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Api\V1\AuthController;
use App\Http\Controllers\Api\V1\InitialInstall;
use App\Http\Controllers\Api\V1\DashboardController;
use App\Http\Controllers\Api\V1\DashletController;
use App\Http\Controllers\Api\V1\UserController;
use App\Http\Controllers\Api\V1\NmapController;
use App\Http\Controllers\Api\V1\NdiffController;
use App\Http\Controllers\Api\V1\ScheduledNmapScanController;
use App\Http\Controllers\Api\V1\NmapProfileController;
use App\Http\Controllers\Api\V1\AuthServerController;
use App\Http\Controllers\Api\V1\CertificateController;
use App\Http\Controllers\Api\V1\NotificationController;
use App\Http\Controllers\Api\V1\SourceController;
use App\Http\Controllers\Api\V1\QueryController;
use App\Http\Controllers\Api\V1\ReportController;
use App\Http\Controllers\Api\V1\SourceGroupController;
use App\Http\Controllers\Api\V1\CheckController;
use App\Http\Controllers\Api\V1\CommandController;
use App\Http\Controllers\Api\V1\GlobalController;
use App\Http\Controllers\Api\V1\SuricataDataController;
use App\Http\Controllers\Api\V1\SuricataConfigController;
use App\Http\Controllers\Api\V1\SuricataRuleController;
use App\Http\Controllers\Api\V1\SuricataRulesetController;
use App\Http\Controllers\Api\V1\SuricataAlertsController;
use App\Http\Controllers\Api\V1\SuricataScanController;
use App\Http\Controllers\Api\V1\WireSharkController;
use App\Http\Controllers\Api\V1\WiresharkScanController;
use App\Http\Controllers\Api\V1\WiresharkCaptureController;
use App\Http\Controllers\Api\V1\WiresharkOverviewController;
use App\Http\Controllers\Api\V1\LicenseController;
use App\Http\Controllers\Api\V1\ProfileController;
use App\Http\Controllers\Api\V1\BackupController;
use App\Http\Controllers\Api\V1\EnvironmentController;
use App\Http\Controllers\Api\V1\SystemController;
use App\Http\Controllers\Api\V1\NagiosServersController;
use App\Http\Controllers\Api\V1\ServiceHostnamesController;
use App\Http\Controllers\Api\V1\SnmpReceiversController;
use App\Http\Controllers\Api\V1\SearchController;
use App\Http\Controllers\Api\V1\ExportController;
use App\Http\Controllers\Api\V1\WiresharkRingBufferController;

Route::prefix('/api/v1')->group(function () {
    Route::post('/install', InitialInstall::class);
    Route::post('/login', [AuthController::class, 'login']);
    Route::post('/logout', [AuthController::class, 'logout']);

    Route::get('/auth/installed', [AuthController::class, 'installed']);
    Route::get('/environment/get', [EnvironmentController::class, 'get']);

    Route::controller(LicenseController::class)->prefix("administration/license")->group(function() {
        Route::get('/', 'get');
        Route::put('/', 'put');
        Route::get('/trial', 'getTrial');
    });
    
    Route::get('/system/get_theme', [SystemController::class, 'getTheme']);
    Route::get('/system/lang', [SystemController::class, 'getGlobalLang']);

    Route::middleware(['auth:sanctum'])->group(function () {
        Route::get('/auth', [AuthController::class, 'get']);

        Route::controller(DashboardController::class)->prefix('dashboard')->group(function () {
            Route::get('/{id?}', 'get');
            Route::post('/', 'post');
            Route::put('/', 'put');
            Route::patch('/', 'patch');
            Route::delete('/', 'delete');
        });

        Route::controller(DashletController::class)->prefix('dashlet')->group(function () {
            Route::get('/', 'get');
            Route::post('/', 'post');
            Route::put('/', 'put');
            Route::delete('/', 'delete');
        });

        Route::controller(UserController::class)->prefix('user')->group(function () {
            Route::get('/{id?}', 'get');
            Route::post('/', 'post');
            Route::put('/', 'put');
            Route::delete('/{id}', 'delete');

            Route::get("/lang/{id}", "getUserLang");
        });

        Route::controller(ProfileController::class)->prefix('profile')->group(function () {
            Route::put('/', 'updatePersonalInformation');
            Route::put('/language', 'updateLanguage');
            Route::put('/theme', 'updateTheme');
            Route::put('/password', 'updatePassword');
            Route::put('/apikey', 'updateAPIKey');
        });

        Route::controller(SourceController::class)->prefix('source')->group(function () {
            Route::get('/{id?}', 'get');
            Route::post('/', 'post');
            Route::put('/', 'put');
            Route::delete('/{id}', 'delete');

            Route::get('/summary/chart/{id?}', 'getSummaryChart');
            Route::get('/summary/talkers/{id?}', 'getSummaryTalkers');
            Route::post('/{id}/reports/run', 'runReport');
            Route::post('/{id}/reports/chords', 'getReportChordData');
            Route::post('/start/{id}', 'start');
            Route::post('/stop/{id}', 'stop');
            Route::post('/restart/{id}', 'restart');
            Route::get('/status/{id}', 'status');

            Route::controller(QueryController::class)->prefix('queries')->group(function (){
                Route::post('/run', 'post');
            });
        });

        Route::controller(SystemController::class)->prefix('system')->group(function () {
            Route::get('/cpu_status', 'cpuStatus');
            Route::get('/memory_status', 'memoryStatus');
            Route::get('/root_drive_status', 'rootDriveStatus');
            Route::get('/get_product_info', 'getProductInfo');
            Route::get('/do_update_check', 'doUpdateCheck');
            Route::get('/backup_cron_status', 'backupCronStatus');
            Route::get('/do_backup', 'doBackup');
            Route::get('/installed_integrations', 'installedIntegrations');
        });

        Route::controller(SourceGroupController::class)->prefix('sourcegroup')->group(function () {
            Route::get('/{id?}', 'get');
            Route::post('/', 'post');
            Route::put('/', 'put');
            Route::delete('/', 'delete');

            Route::get('/summary/chart/{id?}', 'getSourceGroupSummaryChart');
            Route::get('/summary/talkers/{id?}', 'getSourceGroupSummaryTalkers');
            Route::post('/{id}/reports/run', 'runSourceGroupReport');
            Route::post('/{id}/reports/sankeys', 'getSourceGroupReportSankeyData');
            Route::post('/start/{id}', 'start');
            Route::post('/stop/{id}', 'stop');
            Route::post('/restart/{id}', 'restart');
        });

        Route::controller(ReportController::class)->prefix('report')->group(function () {
            Route::get('/{id?}', 'get');
            Route::post('/', 'post');
            Route::put('/', 'put');
            Route::delete('/{id}', 'delete');
            Route::post('/toggle/{id}', 'toggle');
        });
        
        Route::controller(CheckController::class)->prefix('check')->group(function () {
            Route::get('/{id?}', 'get');
            Route::post('/', 'post');
            Route::put('/{id}', 'put');
            Route::delete('/{id}', 'delete');

            Route::get('/forceCheck/{id}', 'forceCheck');
            Route::put('/toggleActive/{id}', 'toggleActive');
        });

        Route::controller(CommandController::class)->prefix('command')->group(function () {
            Route::get('/{id?}', 'get');
            Route::post('/', 'post');
            Route::put('/{id}', 'put');
            Route::delete('/{id}', 'delete');
        });

        Route::controller(NagiosServersController::class)->prefix('nagios_server')->group(function () {
            Route::get('/{id?}', 'get');
            Route::post('/', 'post');
            Route::put('/{id}', 'put');
            Route::delete('/{id}', 'delete');
        });

        Route::controller(ServiceHostnamesController::class)->prefix('service_hostname')->group(function () {
            Route::get('/{id?}', 'get');
            Route::post('/', 'post');
            Route::put('/{id}', 'put');
            Route::delete('/{id}', 'delete');
        });

        Route::controller(SnmpReceiversController::class)->prefix('snmp_receiver')->group(function () {
            Route::get('/{id?}', 'get');
            Route::post('/', 'post');
            Route::put('/{id}', 'put');
            Route::delete('/{id}', 'delete');
        });

        Route::controller(NmapController::class)->prefix('nmap')->group(function () {
            Route::get('/{id?}', 'get')->where('id', '[0-9]+');
            Route::post('/', 'post');
            Route::delete('/', 'delete');

            Route::get('/version', 'getVersion');
            Route::get('/overview', 'getOverview');
            Route::get('/download/{filename}', 'download');
            Route::post('/{id}/stop', 'stop')->where('id', '[0-9]+');

            Route::get('/test/{id}', 'getNmapServiceData');

            Route::controller(ScheduledNmapScanController::class)->prefix('scheduledscan')->group(function () {
                Route::get('/{id?}', 'get')->where('id', '[0-9]+');
                Route::post('/', 'post');
                Route::put('/{id}', 'put')->where('id', '[0-9]+');
                Route::delete('/', 'delete');
                Route::get('/summary/chart/{id}', 'getScheduledScanChartData');
            });

            Route::controller(NmapProfileController::class)->prefix('profile')->group(function () {
                Route::get('/{id?}', 'get')->where('id', '[0-9]+');
                Route::post('/', 'post');
                Route::put('/{id}', 'put')->where('id', '[0-9]+');
                Route::delete('/', 'delete');
            });

            Route::controller(NdiffController::class)->prefix('ndiff')->group(function () {
                Route::get('/{id?}', 'get')->where('id', '[0-9]+');
                Route::post('/', 'post');
                Route::delete('/', 'delete');

                Route::get('/download/{filename}', 'download');
            });
        });

        Route::controller(AuthServerController::class)->prefix('auth_servers')->group(function () {
            Route::get('/', 'get');
            Route::post('/', 'post');
            Route::put('/', 'put');
            Route::delete('/{id}', 'delete');

            Route::post('/validate', 'validate');
            Route::post('/import', 'importUsers');
            Route::post('/query', 'queryAuthServer');
        });

        Route::controller(CertificateController::class)->prefix("certificates")->group(function() {
            Route::get('/', 'get');
            Route::post('/', 'post'); 
            Route::delete('/{id}', 'delete');

            Route::post('/parse', 'parse');
        });

        Route::prefix('administration')->group(function () {
            Route::get('/global', [GlobalController::class, 'get']);
            Route::put('/global', [GlobalController::class, 'put']);
            Route::get('/notifications', [NotificationController::class, 'get']);
            Route::post('/notifications', [NotificationController::class, 'test']);
            Route::put('/notifications', [NotificationController::class, 'put']);

            Route::controller(BackupController::class)->prefix('backup')->group(function () {
                Route::get('/', 'get');
                Route::post('/', 'post');
                Route::delete('/{id}',  'delete');

                Route::get('/{id}/download', 'download');
            });
        });

        Route::controller(WireSharkController::class)->prefix('wireshark')->group(function () {
            Route::get('/getinterface', 'getInterface');
            Route::get('/getversion', 'getVersion');
            Route::post('/startscan', 'startScan');
            Route::get('/getpacketdetails', 'getPacketDetails');
            Route::post('/stopscan', 'stopScan');
            Route::get('/gethistorypackets/{id}', 'getHistoryPackets');
            Route::get('/latestscan','getLatestScan');

            Route::prefix('/scan')->controller(WiresharkScanController::class)->group(function () {
                Route::get('/','get');
                Route::delete('/','delete');

                Route::get('/download/{id}','download');
                Route::post('/import','import');
                Route::post('/scanWithSuricata','scanWithSuricata');
            });

            Route::prefix('summary')->controller(WiresharkCaptureController::class)->group(function () {
                Route::get('/getcaptureinfo', 'getCaptureInfo');
                Route::get('/gettoptalkers', 'getTopTalkers');
                Route::get('/getprotocolusage','getProtocolUsage');
                Route::get('/getpacketsizedistribution','getPacketSizeDistribution');
            });

            Route::prefix('overview')->controller(WiresharkOverviewController::class)->group(function () {
                Route::get('/', 'get');

                Route::get('/getscanovertime', 'scansOverTime');
                Route::get('/getAllScansData', 'getAllScansData');
            });
            Route::prefix('ringbuffer')->controller(WiresharkRingBufferController::class)->group(function (){
                Route::get('/','get');
                Route::post('/edit','edit');
                Route::post('/start','start');
                Route::post('/create','create');
                Route::post('/stop','stop');
                Route::get('/view','view');
                Route::get('/tempfile','getTempFile');
                Route::post('/download', 'download');
            });
        });
        
        Route::prefix('/suricata')->group(function () {
            Route::controller(SuricataDataController::class)->group(function () {
                Route::get('/get', 'getSuricataData');
                Route::get('/fulljson', 'getFullLog');
                Route::get('/whois', 'getWhois');
                Route::get('/reverseDNS', 'getReverseDNS');
                Route::post('/import-pcap', 'importPcap');
                Route::get('/jsonfiles', 'getAllJson');
            });

            Route::controller(SuricataConfigController::class)->group(function () {
                Route::get('/config', 'getConfig');
                Route::put('/config', 'updateConfig');
                Route::get('/version', 'getVersion');
            });

            Route::controller(SuricataRuleController::class)->prefix('/rules')->group(function () {
                Route::get('/', 'getSuricataRules');
                Route::put('/toggle', 'toggleRules');
                Route::put('/delete', 'deleteRules');
                Route::get('/fullrule', 'getFullRule');
                Route::put('/edit', 'editRule');
                Route::post('/import', 'importRules');
                Route::get('/rulesFiles', 'getAllRulesFile');
            });

            Route::controller(SuricataRulesetController::class)->prefix('/rulesets')->group(function () {
                Route::get('/getRulesets', 'getRulesets');
                Route::get('/getRuleset', 'getRuleset');
                Route::put('/toggle', 'toggleRulesets');
                Route::put('/addRuleset', 'addRuleset');
                Route::put('/editRuleset', 'editRuleset');
                Route::delete('/delete', 'deleteRuleset');
            });

            Route::controller(SuricataAlertsController::class)->prefix('/alerts')->group(function () {
                Route::get('/get', 'get');

                Route::get('/getTotal', 'getTotalWeeklyAlerts');
                Route::get('/getCategories', 'getCategories');
                Route::get('/getSeverities', 'getSeverities');
                Route::get('/getTopAlerts', 'getTopAlerts'); 
            });

            Route::controller(SuricataScanController::class)->prefix('/scan')->group(function () {
                Route::get('/', 'get');
                Route::post('/', 'post');

                Route::post('/isRunning', 'isRunning');
            });
        });
        Route::controller(SearchController::class)->prefix('/search')->group(function () {
            Route::get('/', 'get');
        });
        Route::controller(ExportController::class)->prefix('/export')->group(function () {
            Route::get('/login', 'login');
            Route::get('/', 'get');
            Route::post('/', 'post');
        });
    });
});

Route::get('/{any}', function () {
    return view('app');
})->where('any', '.*');
