import { AppSidebar } from "@/components/AppSideBar";
import {
  SidebarInset,
  SidebarProvider,
} from "@/components/ui/sidebar"
import { Header } from "@/components/header/Header"
import { Toaster } from "@/components/ui/sonner"
import { PageContainer } from "@/components/Page";

export default function Layout({ children }: { children: React.ReactNode }) {
  return (
      <SidebarProvider>
          <AppSidebar />
          <SidebarInset className="overflow-hidden">
            <Header />
            <PageContainer>
              {children}
            </PageContainer>
            <Toaster />
          </SidebarInset>
      </SidebarProvider>
  )
}
