import { useEchoNotification } from "@laravel/echo-react";
import { Bell } from "lucide-react";
import { Button } from "@/components/ui/button";
import { useState } from "react";
import { useAuth } from "@/contexts/AuthContext";

export default function NotificationIndicator() {

  const { user } = useAuth();
  const [notifications, setNotifications] = useState<{id: string, type: string}[]>([]);
  useEchoNotification(
    `App.Models.User.${user?.id}`,
    (notification) => {
      setNotifications(prev => { return [...prev, notification]; });
    },
  );

  function handleClick() {
    console.log(notifications);
    setNotifications([]);
  }

  return (
    <Button
      variant="secondary"
      className="rounded-full relative gap-0"
      onClick={handleClick}
    >
      <div className={`transition-opacity duration-200 ${notifications.length <= 0 ? "opacity-0" : "opacity-100"}`}>
        <span className="absolute right-0 top-0 inline-flex size-3 animate-ping rounded-full bg-primary opacity-75"></span>
        <span className="absolute right-0 top-0 inline-flex size-3 rounded-full bg-primary"></span>
      </div>
      <Bell />
    </Button>
  )
}