import { Input } from "@/components/ui/input";
import { Select, SelectTrigger, SelectValue, SelectContent, SelectItem } from "@/components/ui/select";
import { Checkbox } from "@/components/ui/checkbox";
import { Table, TableBody, TableCell, TableHead, TableHeader, TableRow } from "../ui/table";
import { ScrollArea } from "../ui/scroll-area";
import { useFieldArray } from "react-hook-form";
import { useTranslation } from "react-i18next";
import { UseFormReturn } from "react-hook-form";
import { ImportUser } from "@/components/administration/types";

interface ImportUserStep3Props {
  formImport: UseFormReturn<{ formUsers: ImportUser[] }>;
  formUsers: ImportUser[];
  selectedIndices: number[];
  setSelectedIndices: React.Dispatch<React.SetStateAction<number[]>>;
}

export default function ImportUserStep3({ formImport, formUsers, selectedIndices, setSelectedIndices }: ImportUserStep3Props) {
  const { t } = useTranslation();
  const { control } = formImport;
  const { fields, update } = useFieldArray({
    control,
    name: "formUsers",
  });

  return (
    <>
        <div className="bg-card px-4 pb-4 flex items-center justify-end border-b">
            <div className="flex text-sm text-muted-foreground items-center gap-4">
                <div>
                    {t("Selected Users")} {selectedIndices.length}
                </div>
                <div>
                    <span className="inline-block w-2 h-2 rounded-full bg-success"></span> {" "} 
                    {
                        selectedIndices.filter(index => 
                            formImport.watch(`formUsers.${index}.username`)?.trim() && 
                            formImport.watch(`formUsers.${index}.email`)?.trim()
                        ).length
                    }
                </div>
                <div>
                    <span className="inline-block w-2 h-2 rounded-full bg-error"></span> {" "}
                    {
                        selectedIndices.filter(index => 
                            !formImport.watch(`formUsers.${index}.username`)?.trim() || 
                            !formImport.watch(`formUsers.${index}.email`)?.trim()
                        ).length
                    }
                </div>
            </div>
        </div>
        
        <ScrollArea className="h-130">
            <Table>
                <TableHeader className="p-4 sticky top-0 bg-background">
                    <TableRow>
                        <TableHead className="text-muted-foreground">                                                
                            <Checkbox
                                checked={selectedIndices.length === formUsers.length}
                                onCheckedChange={(checked) => {
                                    if (checked) {
                                        setSelectedIndices(formUsers.map((_, index) => index));
                                    } else {
                                        setSelectedIndices([]);
                                    }
                                }}
                            />
                        </TableHead>
                        <TableHead className="text-muted-foreground">{t("Display Name")}</TableHead>
                        <TableHead className="text-muted-foreground ">{t("Username")} <span className="text-error">*</span></TableHead>
                        <TableHead className="text-muted-foreground ">{t("Email")} <span className="text-error">*</span></TableHead>
                        <TableHead className="text-muted-foreground">{t("User Type")} <span className="text-error">*</span></TableHead>
                        <TableHead className="text-muted-foreground ">{t("API Access")}</TableHead>
                        <TableHead className="text-muted-foreground ">{t("Auth Type")}</TableHead>
                        <TableHead className="text-muted-foreground ">{t("Status")}</TableHead>
                    </TableRow>
                </TableHeader>
                

                <TableBody>
                    
                    {fields.map((field, index) => (
                        <TableRow
                            key={field.id}
                            className={
                                selectedIndices.includes(index) &&
                                (!formImport.watch(`formUsers.${index}.username`)?.trim() || 
                                !formImport.watch(`formUsers.${index}.email`)?.trim())
                                    ? 'bg-red-900'
                                    : ''
                            }
                        >
                            <TableCell className="w-[50px]">
                                <Checkbox
                                    checked={selectedIndices.includes(index)}
                                    onCheckedChange={(checked) => {
                                        if (checked) {
                                            setSelectedIndices(prev => [...prev, index]);
                                        } else {
                                            setSelectedIndices(prev => prev.filter(i => i !== index));
                                        }
                                    }}
                                />
                            </TableCell>
                            <TableCell className="w-[300px]">
                                <Input
                                    {...formImport.register(`formUsers.${index}.displayname`, { required: false })}
                                    className={formImport.watch(`formUsers.${index}.displayname`) ? 'border-primary' : 'border-red-500'}
                                />
                            </TableCell>
                            <TableCell className="w-[300px]">
                                <Input
                                    {...formImport.register(`formUsers.${index}.username`, { required: true })}
                                    className={formImport.watch(`formUsers.${index}.username`) ? 'border-primary' : 'border-red-500'}
                                />
                            </TableCell>
                            <TableCell className="w-[300px]">
                                <Input
                                    {...formImport.register(`formUsers.${index}.email`, { required: true })}
                                    className={formImport.watch(`formUsers.${index}.email`) ? 'border-primary' : 'border-red-500'}
                                />
                            </TableCell>
                            <TableCell className="w-[150px]">
                                <Select
                                    value={String(field.is_admin)}
                                    onValueChange={(val) => update(index, { ...field, is_admin: val === "true" })}
                                >
                                    <SelectTrigger>
                                        <SelectValue />
                                    </SelectTrigger>
                                    <SelectContent>
                                        <SelectItem value="false">{t("User")}</SelectItem>
                                        <SelectItem value="true">{t("Admin")}</SelectItem>
                                    </SelectContent>
                                </Select>
                            </TableCell>
                            <TableCell className="w-[150px]">
                                <Select
                                    value={String(field.apiaccess)}
                                    onValueChange={(val) => update(index, { ...field, apiaccess: val === "true" })}
                                >
                                    <SelectTrigger>
                                        <SelectValue />
                                    </SelectTrigger>
                                    <SelectContent>
                                        <SelectItem value="false">{t("No")}</SelectItem>
                                        <SelectItem value="true">{t("Yes")}</SelectItem>
                                    </SelectContent>
                                </Select>
                            </TableCell>
                            <TableCell className="text-muted-foreground w-[100px]">
                                {field.type}
                            </TableCell>
                            <TableCell className="w-[150px]">
                                {formImport.watch(`formUsers.${index}.username`)?.trim() && formImport.watch(`formUsers.${index}.email`)?.trim() ? (
                                    <div className="flex items-center gap-2">
                                        <span className="inline-block w-2 h-2 rounded-full bg-success"></span>
                                        {t("Ready")}
                                    </div>
                                ) : (
                                    <div className="flex items-center gap-2">
                                        <span className="inline-block w-2 h-2 rounded-full bg-error"></span>
                                        {t("Incomplete")}
                                    </div>
                                )}
                            </TableCell>
                        </TableRow>
                    ))}
                    
                </TableBody>
            </Table>
        </ScrollArea>
    </>
  );
}