import { Button } from "@/components/ui/button";
import { Input } from "@/components/ui/input";
import { ChevronRight } from "lucide-react";
import { useTranslation } from "react-i18next";
import { useForm, SubmitHandler } from "react-hook-form";
import { Form, FormLabel, FormControl, FormField, FormItem } from "@/components/ui/form";
import { useSetLicense } from "@/components/administration/license/queries";
import type { License } from "@/components/administration/license/types";

type LicenseFormProps = {
  license: License;
}

export default function LicenseForm({ license }: LicenseFormProps) {
  const { t } = useTranslation();
  const setLicense = useSetLicense();

  const form = useForm<License>({
    values: {
      key: license.key,
    },
  });

  const onSubmit: SubmitHandler<License> = (data) => {
    setLicense.mutate(data.key);
    form.reset();
  };

  return (
    <Form {...form}>
      <form onSubmit={form.handleSubmit(onSubmit)}>
        <div className="flex w-full items-end space-x-2">
          <FormField
            control={form.control}
            name="key"
            render={({ field }) => (
              <FormItem className="w-full">
                <FormLabel>{t("License Key")}</FormLabel>
                <FormControl>
                  <Input {...field} />
                </FormControl>
              </FormItem>
            )}
          />
          <Button>
            {t("Set Key")} <ChevronRight />
          </Button>
        </div>
      </form>
    </Form>
  );
}
