import { useMutation, useQueryClient } from "@tanstack/react-query";
import axios from "axios";
import { useTranslation } from "react-i18next";
import { toast } from "sonner";

export function useSetLicense() {
    const queryClient = useQueryClient();
    const { t } = useTranslation();

    return useMutation({
        mutationFn: (key: string) =>
            axios.put("/api/v1/administration/license", {
                key
            }),
        onSuccess: () => {
            queryClient.invalidateQueries({ queryKey: ["trial"] });
            queryClient.invalidateQueries({ queryKey: ["license"] });
            toast(t("Valid license key. License key updated successfully"));
        },
        onError: (error: any) => {
            if (error?.response?.status === 422) {
                toast(t("License key is invalid."));
            } else {
                toast(t("An error occurred while updating the license key."));
            }
        },
    });
}
