import { Language } from "@/components/user/types";

export type AuthServer = {
  id: number;
  active: boolean;
  name: string;
  host: string;
  type: string;
  basedn: string;
  encryption: string;
  suffix: string;
  controllers: string;
  port: number;
}

export type AuthValidationErrorResponse = {
  error_code?: string;
  message?: string;
  details?: string;
}

export type FormValueSignin = {
  username: string;
  password: string;
  server: AuthServer;
}

export type AuthServerUser = {
  cn: string;
  username: string;
  email?: string;
  dn: string;
  displayname: string;
  sn: string;
  givenname: string;
  oc: {
    [key: string]: string | number;
    count: number;
  };
}

export type ImportUser = {
  username: string;
  email: string;
  // first_name: string | null;
  // last_name: string | null;
  displayname: string;
  apiaccess: boolean;
  type: string;
  is_admin: boolean;
  auth_server_id: number | undefined;
  auth_server_data: string;
};

export type certificate = {
  id: number;
  subject_cn: string;
  issuer_cn: string;
  valid_to: string;
}

export type ConfigOptions = {
  lang: Language;
  theme: string;
  resolve_hosts: string;
  resolve_hosts_graphs: string;
  cache_time: string;
  rel_map_max: string;
  timezone: string;
}

export type NotificationOptions = {
  notification_channel: Array<'mail' | 'slack' | 'broadcast'>,
  mail_config?: {
    send_from: string,
    mailer: 'smtp' | 'sendmail',
    smtp_config?: {
      host: string,
      port: number,
      username: string,
      password: string,
      encryption: 'tls' | 'ssl' | 'none',
    }
  },
  slack_config?: {

  },
  broadcast_config?: {

  },
}

export type BaseBackup = {
  file_name: string;
  date: string;
  size: string;
}