export type AlertingType = 'user' | 'nagios' | 'snmp_receiver' | 'command';

export type Check = {
  id: number;
  active?: boolean;
  name: string;
  warning: string;
  critical: string;
  alerting_associations?: AlertingAssociation[];
  last_val?: string | undefined;
  last_run?: string | undefined;
  last_code?: string | undefined;
  last_stdout?: string | undefined;
}
export type CheckAssociation = {
  id: string;
}

// Flow Source Check types
export interface FlowSourceCheck extends Check {
  check_type: 'flow_source';
  object_type: 'source' | 'sourcegroup';
  object_id: number;
  metric: FlowSourceCheckMetric;
  raw_query?: string | undefined;
}
export type FlowSourceCheckFormData = {
  check_type: 'flow_source';
  step1: {
    name: string;
    association: CheckAssociation & {
      type: 'source' | 'sourcegroup';
    };
  },
  step2: {
    metric: FlowSourceCheckMetric;
    warning_threshold: string;
    critical_threshold: string;
    queries: FlowSourceCheckQuery[];
  },
  step3: {
    user: number[];
    nagios: number[];
    snmp_receiver: number[];
    command: number[];
  }
}
export type FlowSourceCheckMetric = 'bytes' | 'flows' | 'packets' | 'pps' | 'bps' | 'bpp' | 'abnormal_behavior';
export type FlowSourceCheckQuery = {
  location: 'source' | 'destination' | 'destination_or_source';
  location_type: 'port' | 'ip' | 'network';
  location_bool: 'is' | 'is_not';
  location_value: string;
}

// Nmap Check types
export interface NmapCheck extends Check {
  check_type: 'nmap';
  object_type: 'nmap_scan';
  object_id: number;
  metric: NmapCheckMetrics;
}
export type NmapCheckFormData = {
  check_type: 'nmap';
  step1: {
    name: string;
    association: CheckAssociation & {
      type: 'scheduled_scan';
    };
  },
  step2: {
    metric: NmapCheckMetrics;
    warning_threshold: string;
    critical_threshold: string;
  }
}
export type NmapCheckMetrics = 'ports_open' | 'ports_closed';

// Suricata Check types
export interface SuricataCheck extends Check {
  check_type: 'suricata';
  object_type: 'suricata_scan';
  object_id: number;
  raw_query: string;
  metric: SuricataCheckMetric;
}
export type SuricataCheckFormData = {
  check_type: 'suricata';
  step1: {
    name: string;
    association: CheckAssociation & {
      type: string;
      id: string;
    };
    metric: SuricataCheckMetric;
    warning_threshold: string;
    critical_threshold: string;
    lookback_period: string;
    check_frequency: string;
  },
  step2: {
    user: number[];
    nagios: number[];
    snmp_receiver: number[];
    command: number[];
  }
}
export type SuricataCheckMetric = 'alert_count';

// Command types
export type Command = {
  id: number,
  name: string,
  location: string,
  script: string,
  arguments?: string,
}
export interface CommandFormData extends Omit<Command, 'id'> {}


// Nagios Server types
export type NagiosServer = {
  id: number,
  name: string,
  nrdp_url: string,
  nrdp_token: string,
}
export interface NagiosServerFormData extends Omit<NagiosServer, 'id'> {}


// Service Hostname types
export type ServiceHostname = {
  id: number,
  hostname: string,
  servicename: string,
  server_id: number,
  nagios_server: NagiosServer,
}
export interface ServiceHostnameFormData extends Omit<ServiceHostname, 'id' | 'nagios_server'> {
  server_id: number,
}


// SNMP Receiver types
export type SNMPReceiver = {
  id: number,
  name: string,
  version: '2c' | '3',
  community_string?: string,
  auth_level?: "AuthPriv" | "NoAuthNoPriv" | "AuthNoPriv",
  priv_protocol?: string,
  priv_password?: string,
  auth_protocol?: string,
  auth_password?: string,
  username?: string,
  port: number,
  ip: string,
}
export interface SNMPReceiverFormData extends Omit<SNMPReceiver, 'id'> {}