import { dashboard } from "@/components/dashboard/types";
import { createContext, useContext } from "react";
import { useGetDashboard } from "@/components/dashboard/queries";

type DashboardProviderState = {
  dashboard: dashboard,
}

const initialState: DashboardProviderState = {
  dashboard: {
    id: -1,
    user_id: -1,
    title: '',
    range: '-2 hours',
    refresh_rate: 300000,
    icon: '',
    dashlets: []
  },
}

const DashboardProviderContext = createContext<DashboardProviderState>(initialState);

export function DashboardProvider({
  children,
  ...props
}: { children: React.ReactNode, id: number }) {

  const { data: dashboard, isLoading } = useGetDashboard(props.id);

  if (isLoading || !dashboard) return;

  return (
    <DashboardProviderContext.Provider {...props} value={{ dashboard }}>
      {children}
    </DashboardProviderContext.Provider>
  )
}

export const useDashboard = () => {

  const context = useContext(DashboardProviderContext);

  if (context === undefined)
    throw new Error("useDashboard must be used within a DashboardProvider");

  return context;
}
