import { keepPreviousData, useQuery } from "@tanstack/react-query";
import axios from "axios";
import { 
  MultiSourceDataOptions, 
  TopTalkerDataOptions,
} from "../types";

export function useGetSourceSummaryData(id: number, timeframe: string, props = {}) {
  return useQuery({
    queryKey: ['dashlet', 'source-summary', id, timeframe],
    queryFn: async () => {
      const response = await axios.get(`/api/v1/source/summary/chart/${id}`, {
        params: { timeframe }
      });
      return response.data;
    },
    ...props,
    placeholderData: keepPreviousData,
  });
}

export function useGetSourcesSummaryData(timeframe: string, options: MultiSourceDataOptions, props = {}) {
  return useQuery({
    queryKey: ['dashlet', 'sources-summary', timeframe, options],
    queryFn: async () => {
      const response = await axios.get(`/api/v1/source/summary/chart`, {
        params: {
          timeframe,
          ...options,
        }
      });
      return response.data;
    },
    ...props,
    placeholderData: keepPreviousData,
  });
}

export function useGetSourceTopTalkersData(id: number, timeframe: string, options: TopTalkerDataOptions, props = {}) {
  return useQuery({
    queryKey: ['dashlet', 'source-top-talkers', id, timeframe, options.num_talkers, options.order_by, options.source_id],
    queryFn: async () => {
      const response = await axios.get(`/api/v1/source/summary/talkers/${id}`, {
        params: { timeframe, ...options, n: options.num_talkers[0] }
      });
      return response.data;
    },
    ...props,
    placeholderData: keepPreviousData,
  });
}

export function useGetNmapScheduledScanData(id: number, timeframe: string, props = {}) {
  return useQuery({
    queryKey: ['dashlet', 'nmap-scheduled-scan', id, timeframe],
    queryFn: async () => {
      const response = await axios.get(`/api/v1/nmap/scheduledscan/summary/chart/${id}`, {
        params: { timeframe }
      });
      return response.data;
    },
    ...props,
    placeholderData: keepPreviousData,
  })
}
