import DashboardDropdown from "@/components/dashboard/DashboardDropdown";
import TimeDropdown from "@/components/dashboard/toolbar/TimeDropdown";
import { AddDashletDialog } from "@/components/dashboard/dashlet/AddEditDashletDialog";
import { Button } from "@/components/ui/button";
import { Plus, ChevronsUpDown, ClipboardPlus } from "lucide-react";
import { useParams } from "react-router";
import ExportDropdown from "@/components/dashboard/toolbar/ExportDropdown";
import { AddReportDialog } from "@/components/report/AddEditReportDialog"
import { useTranslation } from "react-i18next";

export default function DashboardToolbar() {

  const { t } = useTranslation();
  const { dashboardId } = useParams();
  
  return (
    <div className="flex justify-between ml-2 mr-3 pt-2">
      <DashboardDropdown align="start">
        <Button
          className="w-7 h-9"
          variant="ghost"
          role="combobox"
        >
          <ChevronsUpDown className="opacity-50" />
        </Button>
      </DashboardDropdown>
      <div className="flex items-center gap-1">
        <AddReportDialog dashboardId={Number(dashboardId)}>
          <Button size="sm" variant="ghost">
            <ClipboardPlus />
            {t("Schedule")}
          </Button>
        </AddReportDialog>
        <ExportDropdown />
        <TimeDropdown />
        <AddDashletDialog dashboardId={Number(dashboardId)}>
          <Button size="sm">
            <Plus />{t("Add Dashlet")}
          </Button>
        </AddDashletDialog>
      </div>
    </div>
  )
}