import { useQuery } from '@tanstack/react-query';
import axios, { AxiosError } from 'axios';
import { UpdateCheck, SuggestReturn } from "@/components/header/types";
import { useEffect, useState } from 'react';

export function useUpdateCheck() {
  return useQuery<UpdateCheck, AxiosError>({
    queryKey: ['updateCheck'],
    queryFn: async () => {
      const response = await axios.get('/api/v1/system/do_update_check');
      return response.data;
    },
    staleTime: 24 * 60 * 60 * 1000, // 24 hours
  });
}

export function useSearchSuggest(value: string){
  const [debouncedInput, setDebouncedInput] = useState(value);
  const inputDelay = 100; // milliseconds

  useEffect(() => {
    const timer = setTimeout(() => {
      setDebouncedInput(value);
    }, inputDelay);

    return () => {
      clearTimeout(timer);
    };
  }, [value, inputDelay]);

  return useQuery({
    queryKey: ['search', debouncedInput],
    queryFn: () => {
        return axios.get('/api/v1/search', {
          params: {
            term: debouncedInput,
          },
        });
    },
    enabled: value.length >= 3 && !!debouncedInput,
    select: (response) => {
        const data: Array<SuggestReturn> = response.data;
        return data;
    },
  });
}
