import { Button } from "@/components/ui/button";
import { useNavigate } from "react-router-dom";
import { useTranslation } from "react-i18next";

export default function NmapNotInstalled() {
  const navigate = useNavigate();
  const { t } = useTranslation();

  return (
    <div className="w-full h-full flex flex-col justify-center items-center">
      <div className="text-2xl font-bold mb-6">
        {t('Nmap Not Installed')}
      </div>
      <Button type="button" onClick={() => navigate("/nmap")}>
        {t('Install Nmap')}
      </Button>
    </div>
  );
}
