import { useDeleteProfiles } from "@/components/nmap/profiles/queries";
import {
  AlertDialog,
  AlertDialogAction,
  AlertDialogCancel,
  AlertDialogContent,
  AlertDialogDescription,
  AlertDialogFooter,
  AlertDialogHeader,
  AlertDialogTitle,
  AlertDialogTrigger,
} from '@/components/ui/alert-dialog';
import React from 'react';
import { useTranslation } from 'react-i18next';

export default function DeleteProfileDialog ({
  ids,
  children,
  open,
  onOpenChange
}: {
  ids: number[];
  children: React.ReactNode;
  open?: boolean;
  onOpenChange?: (open: boolean) => void;
}) {
  const { t } = useTranslation();
  const deleteProfile = useDeleteProfiles();

  return (
    <AlertDialog open={open} onOpenChange={onOpenChange}>
      <AlertDialogTrigger asChild>{children}</AlertDialogTrigger>
      <AlertDialogContent>
        <AlertDialogHeader>
          <AlertDialogTitle> {ids.length > 1
            ? t('Confirm Profiles Deletion')
            : t('Confirm Profile Deletion')}
          </AlertDialogTitle>
          <AlertDialogDescription>{ids.length > 1
            ? t('Are you sure you want to delete these profiles?')
            : t('Are you sure you want to delete this profile?')}
          </AlertDialogDescription>
        </AlertDialogHeader>
        <AlertDialogFooter>
          <AlertDialogCancel>{t('Cancel')}</AlertDialogCancel>
          <AlertDialogAction onClick={() => deleteProfile.mutate(ids)}>
            {t('Delete')}
          </AlertDialogAction>
        </AlertDialogFooter>
      </AlertDialogContent>
    </AlertDialog>
  );
};