import {
  AlertDialog,
  AlertDialogAction,
  AlertDialogCancel,
  AlertDialogContent,
  AlertDialogDescription,
  AlertDialogFooter,
  AlertDialogHeader,
  AlertDialogTitle,
  AlertDialogTrigger,
} from '@/components/ui/alert-dialog';
import React from 'react';
import { useTranslation } from 'react-i18next';
import { useDeleteScheduledScans } from "@/components/nmap/scheduledscans/queries";

export default function DeleteScheduledScanDialog ({
  ids,
  children,
  open,
  onOpenChange
}: {
  ids: number[];
  children: React.ReactNode;
  open?: boolean;
  onOpenChange?: (open: boolean) => void;
}) {
  const { t } = useTranslation();
  const deleteScheduledScan = useDeleteScheduledScans();

  return (
    <AlertDialog open={open} onOpenChange={onOpenChange}>
      <AlertDialogTrigger asChild>{children}</AlertDialogTrigger>
      <AlertDialogContent>
        <AlertDialogHeader>
          <AlertDialogTitle> {ids.length > 1
            ? t('Confirm Scheduled Scans Deletion')
            : t('Confirm Scheduled Scan Deletion')}
          </AlertDialogTitle>
          <AlertDialogDescription>{ids.length > 1
            ? t('Are you sure you want to delete these scheduled scans?')
            : t('Are you sure you want to delete this scheduled scan?')}
          </AlertDialogDescription>
        </AlertDialogHeader>
        <AlertDialogFooter>
          <AlertDialogCancel>{t('Cancel')}</AlertDialogCancel>
          <AlertDialogAction onClick={() => deleteScheduledScan.mutate(ids)}>
            {t('Delete')}
          </AlertDialogAction>
        </AlertDialogFooter>
      </AlertDialogContent>
    </AlertDialog>
  );
};