import { QueryClient, useQuery } from "@tanstack/react-query";
import axios from "axios";

export function useGetProductInfo() {
  return useQuery({
    queryKey: ['productInfo'],
    queryFn: () => axios.get('/api/v1/system/get_product_info').then(res => res.data),
  })
}

export function prefetchIntegrations(queryClient: QueryClient) {
  queryClient.prefetchQuery({
    queryKey: ['installed_integrations'],
    queryFn: () => axios.get('/api/v1/system/installed_integrations').then(res => res.data),
  })
}

export function useGetIntegrations() {
  return useQuery({
    queryKey: ['installed_integrations'],
    queryFn: () => axios.get('/api/v1/system/installed_integrations').then(res => res.data),
  });
}


export function useGetGlobalLanguage() {
  return useQuery({
    queryKey: ['global_language'],
    queryFn: () => axios.get('/api/v1/system/lang').then(res => res.data),
  });
}

export function useGetLanguage({ id }: { id: number | undefined }) {
  return useQuery({
    queryKey: ['language', id],
    queryFn: async () => {
      const login_lang = localStorage.getItem('login_locale');

      if (login_lang) {
        return login_lang;
      }

      const local_lang = localStorage.getItem('locale');
      const global_lang = await axios.get(`/api/v1/system/lang`);

      // if there is a user, get their language
      if (id) {
        const response = await axios.get(`/api/v1/user/lang/${id}`);

        // if the user's language is default, return the global language
        if (response.data.lang === "default") {
          localStorage.setItem('locale', global_lang.data.lang);
          return global_lang.data.lang;
        }

        // set the local language to the user's and return it
        localStorage.setItem('locale', response.data.lang);
        return response.data.lang;
      }

      // if there is a local language, return it
      if (local_lang) {
        return local_lang;
      }

      // if the user is not logged in and there is no set local language, get the global language
      localStorage.setItem('locale', global_lang.data.lang);
      return global_lang.data.lang;
    },
    enabled: !!id || id === undefined,
  });
}
