import { ChartContainer, ChartConfig, ChartTooltip, ChartTooltipContent } from "@/components/ui/chart"
import { BarChart, Bar } from "recharts"

export function SourceTraffic({ data, maxValue }: { data: Array<[number | null]>, maxValue:number } ) {
  const metricPrefix = get_metric_prefix(maxValue);
  const chartConfig = {
    bytes: {
      label: metricPrefix + "B",
      color: "var(--chart-1)",
    },
  } satisfies ChartConfig

  function get_metric_prefix(number:number) {

    if((number / 1e12) > 1) {
        return 'T';
    }
    
    if((number / 1e9) > 1) {
        return 'G';
    }
    
    if((number / 1e6) > 1) {
        return 'M';
    }
    
    if((number / 1e3) > 1) {
        return 'K';
    }
    
    else {
        return 'b';
    }
  }

  function get_metric_number(value: number, prefix: string) {
    switch(prefix) {
        
        case 'T':
          value = value / 1e12;
            break;
        case 'G':
          value = value / 1e9;
            break;
        case 'M':
          value = value / 1e6;
            break;
        case 'B':
        default:
          value = value;
            break;
    }
    
    return value.toFixed(2);
}

  const chartData = data.slice(0, -1).map((item, index) => ({
    bytes: item[0] != null ? get_metric_number(item[0], metricPrefix) : 0,
    timeframe: 30 - index * 5,
  }));

  return (
    <ChartContainer config={chartConfig} className="max-h-[50px] max-w-[200px] w-full">
    <BarChart accessibilityLayer data={chartData}>
      <Bar dataKey="bytes" fill="var(--color-bytes)" radius={4} />
      <ChartTooltip 
          content={<ChartTooltipContent 
            labelFormatter={(_value, payload) => {
              const timeframe = payload?.[0]?.payload?.timeframe;
              return timeframe ? `Traffic ${timeframe} minutes ago` : "Unknown period";
            }}
          />} 
        />
    </BarChart>
  </ChartContainer>
  )
}