import { useTranslation } from "react-i18next";
import type { TopTalkersSummaryProps } from "./types";
import { Skeleton } from "../ui/skeleton";
import {
  Table,
  TableBody,
  TableCell,
  TableHead,
  TableHeader,
  TableRow,
} from "@/components/ui/table"
import {
  Card,
  CardContent,
} from "@/components/ui/card"

export function TopTalkersSummary({ summaryTalkers, isLoading}: TopTalkersSummaryProps) {
  const {t} = useTranslation();
  const talkerSections = [
    { key: "dstip", label: t("Destination IP") },
    { key: "srcip", label: t("Source IP") },
    { key: "dstport", label: t("Dest. Port") },
    { key: "srcport", label: t("Src. Port") },
  ];
  return(
    <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-8">
    {/* TODO: top talkers data can over flow cards on screen sizes, Fix responsiveness */}
    {talkerSections.map(section => {
      const talkerList = summaryTalkers?.[section.key];
      return (
      <Card key={section.key}>
        <CardContent>
        <Table>
          <TableHeader>
            <TableRow>
              <TableHead>{section.label}</TableHead>
              <TableHead className="text-right">% {t('Bytes')}</TableHead>
            </TableRow>
          </TableHeader>
          <TableBody>
            {isLoading ? (
              Array.from({ length: 5 }).map((_, idx) => (
                <TableRow key={idx}>
                  <TableCell colSpan={2}>
                    <Skeleton className="w-full h-5" />
                  </TableCell>
                </TableRow>
              ))
            ) : talkerList && talkerList.length > 1 ? (
              talkerList.slice(1).map((talker, idx) => (
                <TableRow key={idx}>
                  {/* TODO: Make the key link to queries section with raw query of the key */}
                  <TableCell>{talker[section.key]}</TableCell>
                  <TableCell className="text-right">{talker.bytespercent}</TableCell>
                </TableRow>
              ))
            ) : (
            <TableRow>
              <TableCell colSpan={2} className="text-center text-muted-foreground">
                {t('No data available')}
              </TableCell>
            </TableRow>
          )}
          </TableBody>
        </Table>
        </CardContent>
        </Card>
      );
    })}
    </div>
  )
}