"use client"

import { ColumnDef } from "@tanstack/react-table"
import { DataTableColumnHeader } from "@/components/ui/DataTable/DataTableColumnHeader"
import { QueryResults } from "@/components/source/types";

export const columns = () : ColumnDef<QueryResults>[] => [
  {
    id: "Flow Start",
    accessorKey: "flow_start",
    header: ({ column }) => {
      return <DataTableColumnHeader column={column} title="Flow Start"/>
    },
  },
  {
    id: "Flow End",
    accessorKey: "flow_end",
    header: ({ column }) => {
      return <DataTableColumnHeader column={column} title="Flow End"/>
    },
  },
  {
    accessorKey: "duration",
    header: ({ column }) => {
      return <DataTableColumnHeader column={column} title="Duration"/>
    },
  },
  {
    id: "Source IP",
    accessorKey: "srcip",
    header: ({ column }) => {
      return <DataTableColumnHeader column={column} title="Source IP"/>
    },
  },
  {
    id: "Destination IP",
    accessorKey: "dstip",
    header: ({ column }) => {
      return <DataTableColumnHeader column={column} title="Destination IP"/>
    },
  },
  {
    id: "Source Port",
    accessorKey: "srcport",
    header: ({ column }) => {
      return <DataTableColumnHeader column={column} title="Source Port"/>
    },
  },
  {
    id: "Destination Port",
    accessorKey: "dstport",
    header: ({ column }) => {
      return <DataTableColumnHeader column={column} title="Destination Port"/>
    },
  },
  {
    accessorKey: "packets",
    header: ({ column }) => {
      return <DataTableColumnHeader column={column} title="Packets"/>
    },
  },
  {
    accessorKey: "bytes",
    header: ({ column }) => {
      return <DataTableColumnHeader column={column} title="Bytes"/>
    },
  },
  {
    accessorKey: "flows",
    header: ({ column }) => {
      return <DataTableColumnHeader column={column} title="Flows"/>
    },
  },
  {
    
    id: "Bits/Second",
    accessorKey: "bitspersec",
    header: ({ column }) => {
      return <DataTableColumnHeader column={column} title="Bits/Second"/>
    },
  },
  {
    id: "Packets/Second",
    accessorKey: "packetspersec",
    header: ({ column }) => {
      return <DataTableColumnHeader column={column} title="Packets/Second"/>
    },
  },
  {
    id: "Bytes/Packet",
    accessorKey: "bytesperpacket",
    header: ({ column }) => {
      return <DataTableColumnHeader column={column} title="Bytes/Packet"/>
    },
  },
]