export type dataShown = {
  dataShown: string;
};

export type logFileSelected = {
  selectedFile: string
}

export type ScanPcapDialogProps = {
  isOpen: boolean;
  onOpenChange: (isOpen: boolean) => void;
  onSubmit: (params: {
    file: File | null;
    outputFileName: string;
  }) => void;
};

export type SuricataData = {
  data: {
    interface: string;
    time: string;
    "flow ID": string;
    "source IP": string;
    "source port": string;
    "destination IP": string;
    "destination port": string;
    protocol: string;
    "event type": string; 
  }[];
  total: number;
};

export type WhoisData = {
  whois: string;
}

export type ReverseDNSData = {
  ptr: string;
}

export type ImportPcapParams = {
  file: File;
  output_file_name: string;
};

export type SuricataPcapScanUpdateEvent = {
  status: 'success' | 'failed';
  message: string;
}