import axios from "axios";
import { useQuery,useMutation, useQueryClient } from "@tanstack/react-query";
import {
  SuricataVersion,
} from "@/components/suricata/types";
import { toast } from "sonner";

export function useCheckSuricata() {
  return useQuery<SuricataVersion>({
    queryKey: ["hasSuricata"],
    queryFn: async () => {
      const response = await axios.get<SuricataVersion>(
        "/api/v1/suricata/version"
      );
      return response.data;
    },
  });
}

type ScanDetails = {
  running: boolean;
  started_at: string;
  current_eve_log: string;
}

export function useGetScanDetails() {
  return useQuery<ScanDetails>({
    queryKey: ["ScanDetails"],
    queryFn: async () => {
      const response = await axios.get<ScanDetails>(
        "/api/v1/suricata/scan"
      );
      return response.data;
    },
    refetchInterval: 1 * 60 * 1000,
  });
}

export function usePostScanAction() {
  const queryClient = useQueryClient();

  return useMutation({
    mutationFn: async (action: "start" | "stop") => {
      const response = await axios.post("/api/v1/suricata/scan", { action });
      return response.data;
    },
    onSuccess: (_, action) => {
      const message = action === "start"
        ? "Scan started successfully."
        : "Scan stopped successfully.";
      toast.success(message);
      queryClient.invalidateQueries({ queryKey: ["ScanDetails"] });
    },
    onError: (error, action) => {
      const message = action === "start"
        ? `Failed to start scan: ${error.message}`
        : `Failed to stop scan: ${error.message}`;
      toast.error(message);
    }
  });
}

export function useIsRunning() {
  const queryClient = useQueryClient();

  return useMutation({
    mutationFn: async () => {
      const response = await axios.post("/api/v1/suricata/scan/isRunning");
      return response.data;
    },
    onSuccess: () => {
      queryClient.invalidateQueries({ queryKey: ["ScanDetails"] });
    }
  });
}
