import {
  DropdownMenu,
  DropdownMenuTrigger,
  DropdownMenuContent,
  DropdownMenuItem,
} from "@/components/ui/dropdown-menu";
import { Button } from "@/components/ui/button";
import { useTranslation } from "react-i18next";
import { Ellipsis, Trash2, Pencil } from "lucide-react";
import { AddEditRuleSheet } from "@/components/suricata/rules/AddEditRuleSheet";
import { useState } from "react";
import DeleteRulesAlert from "@/components/suricata/rules/DeleteRulesAlert";
import { AlertDialog } from "@/components/ui/alert-dialog";
import { RuleOptionsProps } from "@/components/suricata/rules/types";

export function RulesDropdown({ sid }: RuleOptionsProps) {
  const { t } = useTranslation();
  const [isEditOpen, setIsEditOpen] = useState(false);
  const [isDeleteOpen, setIsDeleteOpen] = useState(false);
  const handleEdit = () => setIsEditOpen(true);
  const handleDelete = () => setIsDeleteOpen(true);

  return (
    <>
      <DropdownMenu>
        <DropdownMenuTrigger asChild>
          <Button
            variant="ghost"
            size="sm"
            className="ml-auto hidden h-8 lg:flex"
          >
            <Ellipsis />
          </Button>
        </DropdownMenuTrigger>
        <DropdownMenuContent align="end">
          <DropdownMenuItem
            className="cursor-pointer"
            onClick={handleEdit}
          >
            <Pencil />
            {t("Edit")}
          </DropdownMenuItem>
          <DropdownMenuItem
            className="cursor-pointer"
            onClick={handleDelete}
          >
            <Trash2 />
            {t("Delete")}
          </DropdownMenuItem>
        </DropdownMenuContent>
      </DropdownMenu>
      <AddEditRuleSheet
          open={isEditOpen}
          setOpen={setIsEditOpen}
          sid={sid}
          title="Edit Rule"
          description="Edit your Suricata rule."
      />
      <AlertDialog open={isDeleteOpen} onOpenChange={setIsDeleteOpen}>
          <DeleteRulesAlert sid={sid} />
      </AlertDialog>
    </>
  );
}
