import { useDeleteRuleset } from "@/components/suricata/rules/rulesets/queries";
import {
  AlertDialogAction,
  AlertDialogCancel,
  AlertDialogContent,
  AlertDialogDescription,
  AlertDialogFooter,
  AlertDialogHeader,
  AlertDialogTitle,
} from '@/components/ui/alert-dialog';
import { useTranslation } from 'react-i18next';

export default function DeleteRulesetAlert({ name }: { name: string }) {
  const { t } = useTranslation();
  const deleteRule = useDeleteRuleset();
  return (
    <AlertDialogContent>
      <AlertDialogHeader>
        <AlertDialogTitle>{t("Confirm Ruleset Deletion")}</AlertDialogTitle>
        <AlertDialogDescription>
          {t("Are you sure you want to delete this ruleset?")}
        </AlertDialogDescription>
      </AlertDialogHeader>
      <AlertDialogFooter>
        <AlertDialogCancel>{t("Cancel")}</AlertDialogCancel>
        <AlertDialogAction
          onClick={() => {
            deleteRule.mutate(name);
          }}
        >
          {t("Delete")}
        </AlertDialogAction>
      </AlertDialogFooter>
    </AlertDialogContent>
  );
}
