import {
  DropdownMenu,
  DropdownMenuTrigger,
  DropdownMenuContent,
  DropdownMenuItem,
} from "@/components/ui/dropdown-menu";
import { Button } from "@/components/ui/button";
import { useTranslation } from "react-i18next";
import { Ellipsis, Trash2, Pencil } from "lucide-react";
import { useState } from "react";
import { AlertDialog } from "@/components/ui/alert-dialog";
import { AddEditRulesetDialog } from "@/components/suricata/rules/rulesets/AddEditRulesetDialog";
import { useEditRuleset } from "@/components/suricata/rules/rulesets/queries";
import DeleteRulesetAlert from "@/components/suricata/rules/rulesets/DeleteRulesetAlert"
type RulesetOptionsProps = {
  name: string;
};

export function RulesetActionsDropdown({ name }: RulesetOptionsProps) {
  const { t } = useTranslation();
  const [isEditOpen, setIsEditOpen] = useState(false);
  const [isDeleteOpen, setIsDeleteOpen] = useState(false);
  const handleEdit = () => setIsEditOpen(true);
  const handleDelete = () => setIsDeleteOpen(true);
  const { mutate: editMutation} = useEditRuleset();

  return (
    <>
      <DropdownMenu>
        <DropdownMenuTrigger asChild>
          <Button
            variant="ghost"
            size="sm"
            className="ml-auto hidden h-8 lg:flex"
          >
            <Ellipsis />
          </Button>
        </DropdownMenuTrigger>
        <DropdownMenuContent align="end">
          <DropdownMenuItem
            className="cursor-pointer"
            onClick={handleEdit}
          >
            <Pencil />
            {t("Edit")}
          </DropdownMenuItem>
          <DropdownMenuItem
            className="cursor-pointer"
            onClick={handleDelete}
          >
            <Trash2 />
            {t("Delete")}
          </DropdownMenuItem>
        </DropdownMenuContent>
      </DropdownMenu>
      <AddEditRulesetDialog
        isOpen={isEditOpen}
        onOpenChange={setIsEditOpen}
        name={name}
        onSubmit={(data) => {
          editMutation(data);
        }}
      />
      <AlertDialog open={isDeleteOpen} onOpenChange={setIsDeleteOpen}>
        <DeleteRulesetAlert name={name}/>
      </AlertDialog>
    </>
  );
}
