import { Table } from "@tanstack/react-table";
import { DataTablePaginationNav } from "@/components/ui/DataTable/DataTablePaginationNav";
import {
  Select,
  SelectContent,
  SelectItem,
  SelectTrigger,
  SelectValue,
} from "@/components/ui/select";

interface DataTablePaginationProps<TData> {
  table: Table<TData>;
  hidePageSizeSelector?: boolean;
}

export function DataTablePagination<TData>({
  table,
  hidePageSizeSelector = false,
}: DataTablePaginationProps<TData>) {

  return (
    <div className="flex items-center justify-between lg:px-2 space-x-6 lg:space-x-8">
      {
        !hidePageSizeSelector && (
          <div className="flex items-center mr-2 pl-2">
            <Select
              value={`${table.getState().pagination.pageSize}`}
              onValueChange={(value) => {
                table.setPageSize(Number(value));
              }}
            >
              <SelectTrigger size="sm" className="w-[70px]">
                <SelectValue
                  placeholder={
                    table.getState().pagination.pageSize
                  }
                />
              </SelectTrigger>
              <SelectContent side="bottom" className="min-w-[4rem]">
                {[10, 20, 30, 40, 50].map((pageSize) => (
                  <SelectItem
                    key={pageSize}
                    value={`${pageSize}`}
                    className="w-15"
                  >
                    {pageSize}
                  </SelectItem>
                ))}
              </SelectContent>
            </Select>
          </div>
        )
      }
      <DataTablePaginationNav table={table} />
    </div>
  );
}