import CopyButton from "@/components/ui/CopyButton";

type TextWithCopyButtonProps = {
  text: string;
  className?: string;
}

export default function TextWithCopyButton({ text, className }: TextWithCopyButtonProps) {
  return (
    <div className={`flex items-center justify-between gap-2 ${className || ""}`}>
      <span className="truncate">{text}</span>
      <CopyButton textToCopy={text} />
    </div>
  );
}
