export type Language = 
  | "bg_BG" | "cs_CZ" | "de_DE" | "en_US" | "es_ES" | "fr_FR" | "it_IT" | "ja_JP" | "ko_KR" | "pl_PL" | "pt_PT" | "ru_RU" | "zh_CN" | "zh_TW" | "default";

// Used for displaying user management table.
export type BaseUser = {
    id: number;
    username: string;
    email: string;
    is_admin: string,
    type: string;
    apiaccess: string;
}

export type ExtendedUser = {
    apikey?: string;
    apikey_id: number;
    auth: string;
    company?: string;
    first_name?: string;
    last_name?: string;
    lang: Language;
    password: string;
    phone?: string;
    theme: string;
    auth_server_id?: number;
    auth_server_data?: string;
    default_dashboard: number;
}

export type User = BaseUser & ExtendedUser;
