import { Button } from "@/components/ui/button"
import {
  Dialog,
  DialogContent,
  DialogDescription,
  DialogFooter,
  DialogHeader,
  DialogTitle,
  DialogTrigger,
} from "@/components/ui/dialog"
import { Input } from "@/components/ui/input"
import { Label } from "@/components/ui/label"
import { useRef, useState } from "react"
import { useImportCapture } from "@/components/wireshark/capturehistory/queries"
import { useTranslation } from "react-i18next"

export default function ImportCaptureDialog() {
  const { t } = useTranslation()
  const inputRef = useRef<HTMLInputElement | null>(null)
  const [file, setFile] = useState<File | null>(null)
  const [open, setOpen] = useState(false)

  const importCapture = useImportCapture({
    onSuccess: () => {
      setFile(null)
      setOpen(false)
    },
  })

  const handleUpload = () => {
    if (!file) return
    const formData = new FormData()
    formData.append("file", file)
    importCapture.mutate(formData)
  }

  return (
    <Dialog open={open} onOpenChange={setOpen}>
      <DialogTrigger asChild>
        <Button>{t("Import PCAP File")}</Button>
      </DialogTrigger>
      <DialogContent className="sm:max-w-[425px]">
        <DialogHeader>
          <DialogTitle>{t("Import PCAP File")}</DialogTitle>
          <DialogDescription>
            {t("Upload a .pcap file to view its packets and include it in your capture history.")}
          </DialogDescription>
        </DialogHeader>

        <div className="grid gap-4">
          <div className="grid gap-3">
            <Label htmlFor="pcap-file">{t("PCAP File")}</Label>
            <Input
              id="pcap-file"
              type="file"
              accept=".pcap,.cap,.pcapng"
              ref={inputRef}
              onChange={(e) => setFile(e.target.files?.[0] || null)}
              disabled={importCapture.isPending}
            />
          </div>
        </div>

        <DialogFooter>
          <Button
            onClick={() => setOpen(false)}
            disabled={importCapture.isPending}
          >
            {t("Cancel")}
          </Button>
          <Button
            onClick={handleUpload}
            disabled={importCapture.isPending || !file}
          >
            {importCapture.isPending ? t("Uploading...") : t("Upload")}
          </Button>
        </DialogFooter>
      </DialogContent>
    </Dialog>
  )
}
