import { DataTable } from "@/components/ui/DataTable/DataTable";
import { columns } from "@/components/wireshark/capturehistory/columns";
import {useGetWiresharkScans} from "@/components/wireshark/capturehistory/queries";
import React from 'react';
import DataTableSkeleton from "@/components/ui/DataTable/DataTableSkeleton";
import DeleteCaptureDialog from "@/components/wireshark/capturehistory/DeleteCaptureDialog";
import ImportCaptureDialog from "@/components/wireshark/capturehistory/ImportCaptureDialog";
import { useTranslation } from "react-i18next"



export default function ScanHistoryDataTable() {
  const { data =[], isLoading, isError, error } = useGetWiresharkScans();

  const [deleteDialogOpen, setDeleteDialogOpen] = React.useState(false);
  const [idsToDelete, setIdsToDelete] = React.useState<number[]>([]);
  const { t } = useTranslation();
  const actions = [
    {
      label: t("Delete"),
      value: "delete",
      onClick: async (selectedRows: any) => {
        setIdsToDelete(selectedRows.map((row: any) => row.id));
        setDeleteDialogOpen(true);
      }
    }
  ]
  
  if (isError) {
    return (
      <div>
        {t("Failed to load scans")}: {error.message}
      </div>
    );
  }

  return (
    <div className="p-4">
      <div className="flex justify-between items-center mb-4">
        <h2 className="text-xl font-semibold">{t('Capture History')}</h2>
        <ImportCaptureDialog />
      </div>
      { !isLoading && (<DataTable columns={columns} usesRowSelection={true} selectedRowActions={actions} data={data} />)}
      {isLoading && <DataTableSkeleton />}
      <DeleteCaptureDialog
        ids={idsToDelete}
        open={deleteDialogOpen}
        onOpenChange={(open) => {
          setDeleteDialogOpen(open);
          if (!open) setIdsToDelete([]);
        }}
      >
        <span />
      </DeleteCaptureDialog>

    </div>
  );
}
