import {  useQuery } from '@tanstack/react-query';
import axios, { AxiosError } from 'axios';
import { ProtocolUsage, CaptureInfo,TopTalkersResponse, PacketSizeDistributionResponse ,PacketSizeBucket } from '@/components/wireshark/capturesummary/types';

export function useGetProtocolUsage(captureId: number | string) {
  return useQuery<ProtocolUsage[], AxiosError>({
    queryKey: ['capturesummary', captureId],
    queryFn: async () => {
      const response = await axios.get('/api/v1/wireshark/summary/getprotocolusage', {
        params: { captureId },
      });
      return response.data.protocol_usage;
    },
    enabled: !!captureId, 
  });
}

export function useGetCaptureInfo(captureId: number | string) {
  return useQuery<CaptureInfo, AxiosError>({
    queryKey: ['captureinfo', captureId],
    queryFn: async () => {
      const response = await axios.get('/api/v1/wireshark/summary/getcaptureinfo', {
        params: { captureId },
      });
      return response.data;
    },
    enabled: !!captureId,
  });
}

export function useGetTopTalkers(captureId: number | string) {
  return useQuery<TopTalkersResponse, AxiosError>({
    queryKey: ['toptalkers', captureId],
    queryFn: async () => {
      const response = await axios.get('/api/v1/wireshark/summary/gettoptalkers', {
        params: { captureId },
      });
      return response.data; 
    },
    enabled: !!captureId,
  });
}

export function useGetPacketSizeDistribution(captureId: number | string) {
  return useQuery<PacketSizeBucket[], AxiosError>({
    queryKey: ['packetsizedistribution', captureId],
    queryFn: async () => {
      const response = await axios.get<PacketSizeDistributionResponse>('/api/v1/wireshark/summary/getpacketsizedistribution', {
        params: { captureId },
      });
      return response.data.packet_size_distribution;
    },
    enabled: !!captureId,
  });
}
